/******************************************************************************
* (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
******************************************************************************/

/* ---------------------------------------------------------------
* File: xdostest.c
* -----------------------------------------------------------------*/

#include <xpciapi.h>
#include <stdio.h>
#include <xpci.h>
#include <xhost.h>
#include <xstrutil.h>
#include <xtypedef.h>

#define TRY_PRINTF(fct) printf(">" #fct "\n");BX_TRY((fct)); 
#define TESTDATA_NOB 16

int main(void)
{
  bx_handletype handle; /* the handle of the current connection   */
  bx_int32 reg_value;   /* register values are stored in here     */
  bx_int32 reg_value2;  /* 2nd register to store register values  */
  bx_int32 devid;       /* the device-id of the current card      */
  bx_int32 offset;      /* the offset in the config space         */
  bx_int32 m_select=1;  /* entry user selects from menu           */
  bx_int32 i;           /* used in as counter variable in loops   */
  bx_int32 cardcount=0; /* number of cards found in the system    */
  bx_int32 currentcard; /* number of cards if there is more than one card of a type */
  char *info;           /* needed for results in versionread                        */
  char buf[TESTDATA_NOB]; /* test data will be stored in here  */
                                            /* being printed on the screen  */
                                            /* used as input buffer         */
  bx_int32 possibleCards[]={0x2929,0x2922}; /* all possible cards           */
  char cBuf[20];                            /* needed for function Str2ULong*/
  char * help;                              /* needed for function Str2ULong*/
  BX_TRY_VARS_NO_PROG;                      /* defines for error handling   */


  BX_TRY_BEGIN
  {
    
    printf("Welcome to xdostest.c\n");
    printf("---------------------\n\n");
    printf("These are all E2929A and E2922A cards in your system:\n\n");
    
    /* scanning for best cards in system */
    for(i=0;i<sizeof(possibleCards)/sizeof(bx_int32);i++)
    {
      currentcard=0;
      while(BX_E_OK==BestXDevIdentifierGet(0x15bc,
        possibleCards[i],
        currentcard++,
        &devid))
      {
        printf("There is an E%04xA card with device-id 0x%lx\n",
          possibleCards[i],
          devid);
        cardcount++;
      }
    }
    
    if(cardcount==0)
    {
      printf("\nNo cards could be found in your system. Exiting program\n");
      return 0;
    }
    else
    { 
      printf("\nThere are %ld cards in your system\n",cardcount);
    }
    
    printf("Please enter the device-id of the card you want to open: devid=0x");
    scanf("%s",&cBuf);
    devid = Str2ULong(cBuf, &help, 16);
     
    TRY_PRINTF(BestXOpen(&handle, BX_PORT_PCI_CONF, devid)); 

    printf("\nOk. Now you have a valid connection to the card !\n");
    
    /* running into user menu ... */
    while(m_select)
    {
      m_select=0;
      printf("Menu:\n");
      printf("-----\n");
      printf("Press <0>  to exit\n");
      printf("Press <1>  to list the config space\n");
      printf("Press <2>  to send a test-pattern to the bus\n");
      printf("Press <3>  to perform a versionread\n");
      scanf("%s",&cBuf);
      m_select = Str2ULong(cBuf, &help, 0);
      
      switch(m_select)
      {
        
      case 1: 
        { /* list config space */
          for(offset=0x00;offset<0x40;offset+=0x04)
          { 
            BX_TRY(BestXConfRegRead(handle, offset,      &reg_value));
            printf("Offset: 0x%02x Value:0x%08x\n",offset,reg_value);
          } 
          
          printf("0x40 - 0x5C are reserved\n");

          for(offset=0x60;offset<0x70;offset+=0x04)
          { 
            BX_TRY(BestXConfRegRead(handle, offset,      &reg_value));
            printf("Offset: 0x%02x Value:0x%08x\n",offset,reg_value);
          }
          
          printf("Press <0> to end, anything else to go back to mainmenu\n");
          scanf("%s",&cBuf);
          m_select = Str2ULong(cBuf, &help, 0);
          break;  
        } /* case 1 */
        
      case 2:
        { /* sends a test pattern */
 
          for(i=0;i<TESTDATA_NOB;i++) buf[i]=i;
          
          printf("Please enter a bus-address to send the pattern to: 0x");
          scanf("%s",&cBuf);
          reg_value = Str2ULong(cBuf, &help, 16);
          
          TRY_PRINTF(BestXExerciserReset(handle));
          printf("Set the master enable bit:\n");
          TRY_PRINTF(BestXConfRegWrite(handle,4,0x04100004));
     
          printf("Write the data to be sent into DataMemory:\n");
          TRY_PRINTF(BestXDataMemWrite(handle,0,TESTDATA_NOB,(bx_int8ptr) buf));
          
          /* a) setup board */
          printf("Setup board:\n");
          TRY_PRINTF(BestXBoardDefaultSet(handle));
          TRY_PRINTF(BestXBoardSet(handle,BX_BOARD_RESPECTBIOS,1));
          TRY_PRINTF(BestXBoardProg(handle));          
          
          /* b) Set the RI-Behavior (one line): */
          printf("Set the RI-Behavior:\n");
          TRY_PRINTF(BestXRIGenDefaultSet(handle));
          TRY_PRINTF(BestXRIBehDefaultSet(handle,0));
          
          
          /* c) Set RI-Block */
          
          TRY_PRINTF(BestXRIBlockDefaultSet(handle,0));
          TRY_PRINTF(BestXRIBlockSet(handle,0,BX_RIBLK_INTADDR,0));
          TRY_PRINTF(BestXRIBlockSet(handle,0,BX_RIBLK_BUSCMD,BX_RIBLK_BUSCMD_MEM_WRITEBLOCK));
          TRY_PRINTF(BestXRIBlockSet(handle,0,BX_RIBLK_BUSADDR_LO,reg_value));
          TRY_PRINTF(BestXRIBlockSet(handle,0,BX_RIBLK_NUMBYTES,TESTDATA_NOB));
          TRY_PRINTF(BestXRIBlockSet(handle,0,BX_RIBLK_RESOURCE,BX_RIBLK_RESOURCE_DATAMEM));
          
          /* d) Programm all that  */
          TRY_PRINTF(BestXExerciserProg(handle));

          /* e) start the Exerciser */
          printf("Lets start the exerciser ...\n");
          TRY_PRINTF(BestXExerciserRun(handle));

          printf("Press <0> to end, anything else to go back to mainmenu\n");
          scanf("%s",&cBuf);
          m_select = Str2ULong(cBuf, &help, 0);
          break;
        } /* case 2 */
        
      case 3:
        { /*versionread*/
          
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_CAPI,&info));
          printf("CAPI version: %s\n",info);
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_FIRMWARE,&info));
          printf("BIOS version: %s\n",info);
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_CORE,&info));
          printf("Core version: %s\n",info);
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_XILINX,&info));
          printf("Xilinx version: %s\n",info);
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_PRODUCT,&info));
          printf("Product: %s\n",info);
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_SERIALNO,&info));
          printf("Serial: %s\n",info);
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_BOARDID,&info));
          printf("Board: %s\n",info);
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_MEPHISTO,&info));
          printf("Mephisto: %s\n",info);
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_ALTERA,&info));
          printf("DeepTrace: %s\n",info);
          TRY_PRINTF(BestXVersionRead(handle,BX_VERSION_FIRMWARE_DATE,&info));
          printf("BiosDate: %s\n",info);
          
          printf("Press <0> to end, anything else to go back to mainmenu\n");
          scanf("%s",&cBuf);
          m_select = Str2ULong(cBuf, &help, 0);
          break;
        } /* versionread */
        
      case 0:
      default:
        m_select=0;
        break;
        
      } /*switch */
  
    } /*while(m_select) */
  
  } /* BX_TRY_BEGIN */
  BX_TRY_CATCH
  {
    BestXLastErrorSet(handle, BX_TRY_RET);
    printf (BestXLastErrorStringGet(handle));
    printf("\n");
  }

  TRY_PRINTF(BestXClose(handle));
  return 0;

} /* int main(void) */

